package com.ekoapp.ekosdk.internal.usecase.comment

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.comment.AmityCommentSortOption
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import com.amity.socialcloud.sdk.social.domain.comment.CommentComposerUseCase
import com.ekoapp.core.utils.toV2
import io.reactivex.Flowable
import java.util.concurrent.Executors

internal class CommentPagingDataUseCase {

    fun execute(
        referenceId: String,
        referenceType: String,
        isFilterByParentId: Boolean,
        parentId: String?,
        isDeleted: Boolean?,
        sortOption: AmityCommentSortOption
    ): Flowable<PagingData<AmityComment>> {
        return CommentRepository().getCommentPagingData(
            referenceId,
            referenceType,
            isFilterByParentId,
            parentId,
            isDeleted,
            sortOption
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { comment ->
                CommentComposerUseCase().execute(comment)
            }
        }.toV2()
    }

}