package com.ekoapp.ekosdk.internal.usecase.comment

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.core.reaction.AmityReaction
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import io.reactivex.rxjava3.core.Flowable

internal class CommentReactionListQueryUseCase {

    fun execute(commentId: String, reactionName: String?): Flowable<PagedList<AmityReaction>> {
        return ReactionRepository().getReactionCollection(ReactionReferenceType.COMMENT, commentId, reactionName)
    }

}