package com.ekoapp.ekosdk.internal.usecase.comment

import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import com.amity.socialcloud.sdk.social.domain.comment.CommentComposerUseCase
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class EditCommentUseCase {

    fun execute(
        commentId: String,
        data: JsonObject?,
        metadata: JsonObject?,
        mentionees: List<AmityMentioneeTarget>?
    ): Single<AmityComment> {
        return CommentRepository().editComment(commentId, data, metadata, mentionees)
            .map {
                CommentComposerUseCase().execute(it)
            }
    }
}