package com.ekoapp.ekosdk.internal.usecase.comment

import com.amity.socialcloud.sdk.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import com.amity.socialcloud.sdk.social.domain.comment.CommentComposerUseCase
import io.reactivex.rxjava3.core.Flowable

internal class ObserveSingleCommentUseCase {
    fun execute(commentId: String): Flowable<AmityComment> {
        return CommentRepository().observeComment(commentId)
            .map {
                CommentComposerUseCase().execute(it)
            }
    }
}