package com.ekoapp.ekosdk.internal.usecase.comment

import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import com.ekoapp.ekosdk.internal.constants.COMMENT_ID
import com.ekoapp.ekosdk.internal.constants.FLAG_TYPES
import com.ekoapp.ekosdk.internal.report.AmityFlagType
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import io.reactivex.rxjava3.core.Completable

internal class UnFlagCommentUseCase {

    fun execute(commentId: String, vararg flagTypes: AmityFlagType): Completable {
        EkoPreconditions.checkValidId(commentId, COMMENT_ID)
        EkoPreconditions.checkValidParameter(flagTypes, FLAG_TYPES)
        return CommentRepository().unflagComment(commentId)
    }
}