package com.ekoapp.ekosdk.internal.usecase.community

import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipRepository
import com.ekoapp.ekosdk.internal.constants.COMMUNITY_ID
import com.ekoapp.ekosdk.internal.constants.USER_ID
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import io.reactivex.rxjava3.core.Completable

internal class BanUsersCommunityUseCase {
    fun execute(communityId: String, userIds: List<String>): Completable {
        EkoPreconditions.checkValidParameter(communityId, COMMUNITY_ID)
        EkoPreconditions.checkValidParameter(userIds, USER_ID)
        return CommunityMembershipRepository().banUsers(communityId, userIds)
    }
}