package com.ekoapp.ekosdk.internal.usecase.community

import com.amity.socialcloud.sdk.social.community.AmityCommunity
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import com.amity.socialcloud.sdk.social.domain.community.CommunityComposerUseCase
import com.ekoapp.ekosdk.AmityObjectRepository
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.entity.CommunityEntity
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase

internal class CommunityLiveObjectUseCase : LiveObjectUseCase<CommunityEntity, AmityCommunity>() {


    override fun createRepository(): AmityObjectRepository<CommunityEntity, AmityCommunity> =
        CommunityRepository()

    override fun composeModel(model: AmityCommunity): AmityCommunity =
        CommunityComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.COMMUNITY
}