package com.ekoapp.ekosdk.internal.usecase.community

import com.amity.socialcloud.sdk.social.domain.community.CommunityComposerUseCase
import com.amity.socialcloud.sdk.social.community.AmityCommunity
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import com.ekoapp.ekosdk.internal.constants.DISPLAY_NAME
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class CreateCommunityUseCase {
    fun execute(
        displayName: String,
        description: String?,
        categoryIds: List<String>?,
        isPublic: Boolean?,
        metadata: JsonObject?,
        userIds: List<String>?,
        avatarFileId: String?,
        needApprovalOnPostCreation: Boolean?,
        onlyAdminCanPost: Boolean?
    ): Single<AmityCommunity> {
        EkoPreconditions.checkValidParameter(displayName, DISPLAY_NAME)
        return CommunityRepository().createCommunity(
            displayName,
            description,
            categoryIds,
            isPublic,
            metadata,
            userIds,
            avatarFileId,
            needApprovalOnPostCreation,
            onlyAdminCanPost
        ).map { CommunityComposerUseCase().execute(it) }
    }
}