package com.ekoapp.ekosdk.internal.usecase.community

import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import com.ekoapp.ekosdk.internal.constants.COMMUNITY_ID
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import io.reactivex.rxjava3.core.Completable

internal class JoinCommunityUseCase {
    fun execute(communityId: String): Completable {
        EkoPreconditions.checkValidParameter(communityId, COMMUNITY_ID)
        return CommunityRepository().joinCommunity(communityId)
    }
}