package com.ekoapp.ekosdk.internal.usecase.community

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingData
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategory
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategorySortOption
import com.amity.socialcloud.sdk.social.data.category.CategoryRepository
import io.reactivex.rxjava3.core.Flowable

internal class QueryCommunityCategoryListPagingDataUseCase {

    fun execute(sortOption: AmityCommunityCategorySortOption,
                isDeleted: Boolean?): Flowable<PagingData<AmityCommunityCategory>> {
        return CategoryRepository().getAllCategoriesPagingData(sortOption, isDeleted)
    }

}
