package com.ekoapp.ekosdk.internal.usecase.community

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategory
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategorySortOption
import com.amity.socialcloud.sdk.social.data.category.CategoryRepository
import io.reactivex.rxjava3.core.Flowable

internal class QueryCommunityCategoryListUseCase {

    fun execute(sortOption: AmityCommunityCategorySortOption, isDeleted: Boolean?): Flowable<PagedList<AmityCommunityCategory>> {
        return CategoryRepository().getAllCategories(sortOption, isDeleted)
    }
}
