package com.ekoapp.ekosdk.internal.usecase.community

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.social.community.AmityCommunity
import com.amity.socialcloud.sdk.social.community.AmityCommunityFilter
import com.amity.socialcloud.sdk.social.community.AmityCommunitySortOption
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import io.reactivex.rxjava3.core.Flowable

internal class QueryCommunityListUseCase {

    fun execute(keyword: String,
                categoryId: String,
                filter: AmityCommunityFilter,
                sortBy: AmityCommunitySortOption,
                isDeleted: Boolean?): Flowable<PagedList<AmityCommunity>> {
        return CommunityRepository().getCommunityCollection(
                keyword = keyword,
                categoryId = categoryId,
                filter = filter,
                sortBy = sortBy,
                isDeleted = isDeleted)
    }

}