package com.ekoapp.ekosdk.internal.usecase.community

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.social.community.AmityCommunityMember
import com.amity.socialcloud.sdk.social.community.AmityCommunityMembershipFilter
import com.amity.socialcloud.sdk.social.community.AmityCommunityMembershipSortOption
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipRepository
import com.ekoapp.ekosdk.internal.constants.COMMUNITY_ID
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import io.reactivex.rxjava3.core.Flowable

internal class QueryCommunityMembershipListUseCase {

    fun execute(
        communityId: String,
        roles: List<String>?,
        filter: AmityCommunityMembershipFilter,
        sortBy: AmityCommunityMembershipSortOption
    ): Flowable<PagedList<AmityCommunityMember>> {
        EkoPreconditions.checkValidParameter(communityId, COMMUNITY_ID)
        return CommunityMembershipRepository()
            .getCommunityMembershipCollection(communityId, roles, filter, sortBy)
    }
}