package com.ekoapp.ekosdk.internal.usecase.community

import com.amity.socialcloud.sdk.social.community.AmityCommunity
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import com.amity.socialcloud.sdk.social.domain.community.CommunityComposerUseCase
import io.reactivex.rxjava3.core.Flowable


internal class RecommendedCommunityQueryUseCase {

    fun execute(): Flowable<List<AmityCommunity>> {
        return CommunityRepository().getRecommendedCommunities().map { communityList ->
            communityList.map { community ->
                CommunityComposerUseCase().execute(community)
            }
        }
    }
}