package com.ekoapp.ekosdk.internal.usecase.community

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.social.domain.community.member.CommunityMemberComposerUseCase
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.amity.socialcloud.sdk.social.community.AmityCommunityMember
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipRepository
import com.ekoapp.ekosdk.community.membership.query.AmityCommunityMembership
import io.reactivex.rxjava3.core.Flowable

internal class SearchCommunityMembershipPagingSourceUseCase {

    fun execute(
        communityId: String,
        roles: AmityRoles,
        communityMembership: List<AmityCommunityMembership>?,
        keyword: String
    ): Flowable<PagingData<AmityCommunityMember>> {
        return CommunityMembershipRepository().searchCommunityMembershipPagingData(
            communityId,
            roles,
            communityMembership,
            keyword
        ).map {
            it.map { member -> CommunityMemberComposerUseCase().execute(member) }
        }
    }

}