package com.ekoapp.ekosdk.internal.usecase.community

import com.amity.socialcloud.sdk.social.domain.community.CommunityComposerUseCase
import com.amity.socialcloud.sdk.social.community.AmityCommunity
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class UpdateCommunityUseCase {
    fun execute(
        communityId: String,
        displayName: String?,
        description: String?,
        categoryIds: List<String>?,
        isPublic: Boolean?,
        metadata: JsonObject?,
        avatarFileId: String?,
        needApprovalOnPostCreation: Boolean?,
        onlyAdminCanPost: Boolean?
    ): Single<AmityCommunity> {
        return CommunityRepository()
            .updateCommunity(
                communityId,
                displayName,
                description,
                categoryIds,
                isPublic,
                metadata,
                avatarFileId,
                needApprovalOnPostCreation,
                onlyAdminCanPost
            ).map { CommunityComposerUseCase().execute(it) }
    }
}