package com.ekoapp.ekosdk.internal.usecase.file

import com.amity.socialcloud.sdk.core.AmityVideo
import com.google.gson.JsonObject

internal class GetAvailableVideoQualitiesUseCase {

    fun execute(fileJson: JsonObject?): Array<AmityVideo.Quality> {
        val result = arrayListOf<AmityVideo.Quality>()
        AmityVideo.Quality.values().forEach { quality ->
            val fileId = fileJson?.get(VIDEO_FILE_ID_KEY)?.asJsonObject?.get(quality.apiString)?.asString
            if (!fileId.isNullOrEmpty()) {
                result.add(quality)
            }
        }
        return result.toTypedArray()
    }
}

private const val VIDEO_FILE_ID_KEY = "videoFileId"

