package com.ekoapp.ekosdk.internal.usecase.file

import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.Single

internal class GetFileUseCase {

    fun execute(fileId: String): Single<EkoFileEntity> {
        return Single.fromCallable {
            val file = UserDatabase.get().fileDao().getByIdNow(fileId)
            if (file != null) {
                return@fromCallable file
            } else {
                throw Exception("File is unavailable")
            }
        }
    }
}