package com.ekoapp.ekosdk.internal.usecase.file

import com.amity.socialcloud.sdk.core.AmityVideo
import com.amity.socialcloud.sdk.core.data.file.FileRepository
import com.ekoapp.ekosdk.internal.mapper.AmityFilePropertiesMapper
import com.google.gson.JsonObject
import io.reactivex.Single

internal class GetVideoUrlUseCase {

    fun execute(fileJson: JsonObject?, quality: AmityVideo.Quality? = null): Single<AmityVideo> {
        return parseFileId(fileJson, quality ?: AmityVideo.Quality.ORIGINAL)
                .map { FileRepository().getVideo(it) }
    }

    private fun parseFileId(fileJson: JsonObject?, quality: AmityVideo.Quality): Single<String> {
        return Single.fromCallable {
            val fileId = fileJson?.get(VIDEO_FILE_ID_KEY)?.asJsonObject?.get(quality.apiString)?.asString
            if (fileId != null) {
                return@fromCallable fileId
            } else {
                throw Exception("Video is unavailable")
            }
        }
    }
}

private const val VIDEO_FILE_ID_KEY = "videoFileId"

