package com.ekoapp.ekosdk.internal.usecase.message

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.functions.Predicate

internal class GetMessagePagedListUseCase {

    private var wasEmpty = true

    fun execute(channelId: String,
                stackFromEnd: Boolean,
                parentId: String?,
                isFilterByParentId: Boolean,
                isDeleted: Boolean?,
                includingTags: AmityTags,
                excludingTags: AmityTags,
                type: AmityMessage.DataType?
    ): Flowable<PagedList<AmityMessage>> {

        return MessageRepository().getMessagePagedList(channelId,
                stackFromEnd,
                parentId,
                isFilterByParentId,
                isDeleted,
                includingTags,
                excludingTags,
                type
        )
                .filter(VALID_RESULT)
    }

    private val VALID_RESULT: Predicate<PagedList<AmityMessage>> = Predicate {
        if (it.isNotEmpty() || wasEmpty) {
            wasEmpty = it.isEmpty()
            return@Predicate true
        } else {
            return@Predicate false
        }
    }

}