package com.ekoapp.ekosdk.internal.usecase.message

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.chat.domain.message.MessageComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetMessagePagingDataUseCase {

    fun execute(
        channelId: String,
        parentId: String?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        isFilterByParentId: Boolean,
        isDeleted: Boolean?,
        stackFromEnd: Boolean,
        type: AmityMessage.DataType?
    ): Flowable<PagingData<AmityMessage>> {

        return MessageRepository().getMessagePagingData(
            channelId = channelId,
            isFilterByParentId = isFilterByParentId,
            parentId = parentId,
            includingTags = includingTags,
            excludingTags = excludingTags,
            isDeleted = isDeleted,
            stackFromEnd = stackFromEnd,
            type = type
        )
            .map { pagingData->
                pagingData.map(Executors.newSingleThreadExecutor()) { message ->
                    MessageComposerUseCase().execute(message)
                }
            }
    }

}