package com.ekoapp.ekosdk.internal.usecase.message

import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.chat.domain.message.MessageComposerUseCase
import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.ekoapp.ekosdk.AmityObjectRepository
import com.ekoapp.ekosdk.internal.EkoMessageEntity
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase

internal class MessageLiveObjectUseCase : LiveObjectUseCase<EkoMessageEntity, AmityMessage>() {


    override fun createRepository(): AmityObjectRepository<EkoMessageEntity, AmityMessage> =
        MessageRepository()

    override fun composeModel(model: AmityMessage): AmityMessage =
        MessageComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.MESSAGE
}