package com.ekoapp.ekosdk.internal.usecase.message

import com.amity.socialcloud.sdk.core.AmityTags
import com.ekoapp.ekosdk.internal.repository.comment.CommentLoadResult
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.chat.message.AmityMessage
import io.reactivex.rxjava3.core.Single

internal class MessageManualFirstPageLoadUseCase {

    fun execute(
        channelId: String,
        stackFromEnd: Boolean,
        parentId: String?,
        isFilterByParentId: Boolean,
        isDeleted: Boolean?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        type: AmityMessage.DataType?,
        limit: Int
    ): Single<CommentLoadResult> {
        return MessageRepository().loadFirstPageMessages(
            channelId,
            stackFromEnd,
            parentId,
            isFilterByParentId,
            isDeleted,
            includingTags,
            excludingTags,
            type?.apiKey,
            limit
        )
    }

}