package com.ekoapp.ekosdk.internal.usecase.message

import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.chat.domain.message.MessageComposerUseCase
import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.amity.socialcloud.sdk.core.AmityTags
import io.reactivex.rxjava3.core.Flowable

internal class MessageManualQueryUseCase {

    fun execute(
        channelId: String,
        parentId: String?,
        isFilterByParentId: Boolean,
        isDeleted: Boolean?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        type: AmityMessage.DataType?,
        ids: List<String>,
        hasMore: Boolean
    ): Flowable<List<AmityMessage>> {
        return getDataSource(
            channelId,
            parentId,
            isFilterByParentId,
            isDeleted,
            includingTags,
            excludingTags,
            type,
            ids,
            hasMore
        )
            .map {
                it.map {
                    MessageComposerUseCase().execute(it)
                }
            }
            .map {
                if (isDeleted == null) {
                    it
                } else {
                    it.filter { message -> message.isDeleted() == isDeleted }
                }
            }
    }

    private fun getDataSource(
        channelId: String,
        parentId: String?,
        isFilterByParentId: Boolean,
        isDeleted: Boolean?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        type: AmityMessage.DataType?,
        ids: List<String>,
        hasMore: Boolean
    ): Flowable<List<AmityMessage>> {
        return if (ids.isEmpty() && hasMore) {
            Flowable.never()
        } else {
            observeLocalMessages(
                channelId,
                parentId,
                isFilterByParentId,
                isDeleted,
                includingTags,
                excludingTags,
                type
            )
        }
    }

    private fun observeLocalMessages(
        channelId: String,
        parentId: String?,
        isFilterByParentId: Boolean,
        isDeleted: Boolean?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        type: AmityMessage.DataType?
    ): Flowable<List<AmityMessage>> {
        return MessageRepository().observeMessages(
            channelId = channelId,
            isFilterByParentId = isFilterByParentId,
            parentId = parentId,
            includingTags = includingTags,
            excludingTags = excludingTags,
            isDeleted = isDeleted,
            type = type?.apiKey
        )
    }

}