package com.ekoapp.ekosdk.internal.usecase.message

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.core.reaction.AmityReaction
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.ekoapp.ekosdk.EkoObjectRepository
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import io.reactivex.rxjava3.core.Flowable


internal class MessageReactionListQueryUseCase : EkoObjectRepository() {

    fun execute(messageId: String, reactionName: String?): Flowable<PagedList<AmityReaction>> {
        return ReactionRepository().getReactionCollection(ReactionReferenceType.MESSAGE, messageId, reactionName)
    }

}