package com.ekoapp.ekosdk.internal.usecase.permission

import com.amity.socialcloud.sdk.AmityCoreClient
import com.amity.socialcloud.sdk.core.permission.AmityPermission
import com.ekoapp.ekosdk.permission.PermissionRepository
import io.reactivex.Flowable
import io.reactivex.functions.BiFunction

class ChannelPermissionValidatorUseCase {

    fun execute(permission: AmityPermission, channelId: String): Flowable<Boolean> {
        val membershipPermission = PermissionRepository().getChannelPermission(channelId, AmityCoreClient.getUserId())
        val globalPermission = PermissionRepository().getGlobalPermission(AmityCoreClient.getUserId())
        return Flowable.combineLatest<List<AmityPermission>, List<AmityPermission>, Boolean>(membershipPermission, globalPermission,
                BiFunction<List<AmityPermission>, List<AmityPermission>, Boolean> { t1, t2 ->
                    t1.contains(permission) || t2.contains(permission)
                })
    }

}