package com.ekoapp.ekosdk.internal.usecase.permission

import com.amity.socialcloud.sdk.AmityCoreClient
import com.amity.socialcloud.sdk.core.permission.AmityPermission
import com.ekoapp.ekosdk.permission.PermissionRepository
import io.reactivex.Flowable

class GlobalPermissionValidatorUseCase {

    fun execute(permission: AmityPermission): Flowable<Boolean> {
        return PermissionRepository().getGlobalPermission(AmityCoreClient.getUserId())
                .map { it.contains(permission) }
    }

}