package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.ekoapp.ekosdk.internal.constants.FLAG_TYPES
import com.ekoapp.ekosdk.internal.constants.POST_ID
import com.ekoapp.ekosdk.internal.report.AmityFlagType
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import io.reactivex.rxjava3.core.Completable

internal class FlagPostUseCase {

    fun execute(postId: String, vararg flagTypes: AmityFlagType): Completable {
        EkoPreconditions.checkValidId(postId, POST_ID)
        EkoPreconditions.checkValidParameter(flagTypes, FLAG_TYPES)
        return PostRepository().flagPost(postId)
    }
}