package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.feed.AmityCommunityFeedSortOption
import com.amity.socialcloud.sdk.social.feed.AmityFeedType
import com.amity.socialcloud.sdk.social.feed.AmityPost
import io.reactivex.Flowable

internal class GetCommunityFeedPagedListUseCase {

    fun execute(
        communityId: String,
        sortOption: AmityCommunityFeedSortOption,
        isDeleted: Boolean?,
        feedType: AmityFeedType
    ): Flowable<PagedList<AmityPost>> {
        return PostRepository().getCommunityFeedPagedList(communityId, sortOption, isDeleted, feedType)
    }
}