package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.feed.AmityCommunityFeedSortOption
import com.amity.socialcloud.sdk.social.feed.AmityFeedType
import com.amity.socialcloud.sdk.social.feed.AmityPost
import io.reactivex.Flowable
import java.util.concurrent.Executors

internal class GetCommunityPostPagingDataUseCase {

    @ExperimentalPagingApi
    fun execute(
        communityId: String,
        sortOption: AmityCommunityFeedSortOption,
        isDeleted: Boolean?,
        feedType: AmityFeedType,
        postTypes: List<AmityPost.DataType>
    ): Flowable<PagingData<AmityPost>> {
        return PostRepository().getCommunityPostPagingData(
            communityId = communityId,
            sortOption = sortOption,
            feedType = feedType,
            isDeleted = isDeleted,
            postTypes = postTypes
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { post ->
                PostComposerUseCase().execute(post)
            }
        }
    }
}