package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import io.reactivex.Flowable
import java.util.concurrent.Executors

internal class GetGlobalFeedPagingDataUseCase {

    @ExperimentalPagingApi
    fun execute(): Flowable<PagingData<AmityPost>> {
        return PostRepository().getGlobalFeedPagingData()
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) { post ->
                    PostComposerUseCase().execute(post)
                }
            }
    }
}