package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.amity.socialcloud.sdk.social.feed.AmityUserFeedSortOption

import com.amity.socialcloud.sdk.social.data.post.PostRepository
import io.reactivex.Flowable

internal class GetUserFeedPagedListUseCase {

    fun execute(userId: String, sortOption: AmityUserFeedSortOption, isDeleted: Boolean?): Flowable<PagedList<AmityPost>> {
        return PostRepository().getUserFeedPagedList(userId, sortOption, isDeleted)
    }

}