package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.amity.socialcloud.sdk.social.feed.AmityUserFeedSortOption
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import io.reactivex.Flowable
import java.util.concurrent.Executors

internal class GetUserPostPagingDataUseCase {

    @ExperimentalPagingApi
    fun execute(
        userId: String,
        sortOption: AmityUserFeedSortOption,
        isDeleted: Boolean?,
        postTypes: List<AmityPost.DataType>
    ): Flowable<PagingData<AmityPost>> {
        return PostRepository().getUserPostPagingData(
            userId = userId,
            sortOption = sortOption,
            isDeleted = isDeleted,
            postTypes = postTypes
        ).map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) { post ->
                    PostComposerUseCase().execute(post)
                }
            }
    }
}