package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.core.error.AmityError
import com.amity.socialcloud.sdk.core.error.AmityException
import com.amity.socialcloud.sdk.social.feed.AmityPoll
import com.amity.socialcloud.sdk.social.data.poll.PollRepository
import io.reactivex.rxjava3.core.Flowable

internal class PollGetUseCase {

    fun execute(pollId: String): Flowable<AmityPoll> {
        return if(pollId.isEmpty()) {
            Flowable.error(
                AmityException.create(
                    "pollId not found",
                    null,
                    AmityError.ITEM_NOT_FOUND
                )
            )
        } else {
            PollRepository().observePoll(pollId)
        }
    }
}