package com.amity.socialcloud.sdk.social.domain.post.getbyids

import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import com.amity.socialcloud.sdk.social.feed.AmityPost
import io.reactivex.rxjava3.core.Flowable

internal class PostGetByIdsUseCase {
	
	fun execute(postIds: Set<String>): Flowable<List<AmityPost>> {
		return PostRepository().getPostByIds(postIds.toList())
				.map {
					it.onEach { post ->
						PostComposerUseCase().execute(post)
					}
				}
	}
	
}