package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.core.reaction.AmityReaction
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType

import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import io.reactivex.rxjava3.core.Flowable

internal class PostReactionListQueryUseCase {

    fun execute(postId: String, reactionName: String?): Flowable<PagedList<AmityReaction>> {
        return ReactionRepository().getReactionCollection(ReactionReferenceType.POST, postId, reactionName)
    }

}