package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.feed.AmityFeedType
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import io.reactivex.rxjava3.core.Flowable

internal class PostReactorUseCase {

    fun execute(
        targetType: AmityPost.TargetType,
        targetId: String,
        includeDeleted: Boolean?,
        postTypes: List<AmityPost.DataType>,
        dynamicQueryStreamKeyCreator: DynamicQueryStreamKeyCreator,
        nonce: Int = 0,
        feedType: AmityFeedType? = null
    ): Flowable<AmityPost> {
        return PostRepository().getLatestPost(
            targetType = targetType.apiKey,
            targetId = targetId,
            includeDeleted = includeDeleted,
            postTypes = postTypes,
            feedType = feedType,
            dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
            nonce = nonce
        )
    }
}