package com.ekoapp.ekosdk.internal.usecase.reaction

import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import com.amity.socialcloud.sdk.core.reaction.AmityReaction
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import io.reactivex.rxjava3.core.Flowable

class ReactionReactorUseCase {

    fun execute(
        referenceType: ReactionReferenceType,
        referenceId: String,
        reactionName: String?
    ): Flowable<AmityReaction> {
        return ReactionRepository().getLatestReaction(
            referenceType = referenceType,
            referenceId = referenceId,
            reactionName = reactionName
        )
    }

}