package com.ekoapp.ekosdk.internal.usecase.stream

import com.amity.socialcloud.sdk.video.data.stream.StreamRepository
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution
import io.reactivex.rxjava3.core.Single

internal class CreateStreamBroadcasterUseCase {

    /**
     * Create video stream by broadcaster
     * @return a pair of 'streamId' and nullable 'broadcastingUrl'
     */
    fun execute(
        title: String,
        description: String,
        resolution: AmityBroadcastResolution,
        thumbnailFileId: String? = null
    ): Single<Pair<String, String?>> {
        return StreamRepository().createStreamBroadcaster(
            title = title,
            description = description,
            resolution = resolution,
            thumbnailFileId = thumbnailFileId
        )
    }
}