package com.ekoapp.ekosdk.internal.usecase.stream

import com.ekoapp.ekosdk.internal.repository.stream.StreamSessionRepository
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers
import org.amity.types.ObjectId
import org.joda.time.DateTime

internal class CreateStreamSessionUseCase {

    fun execute(streamId: String, title: String, startedAt: DateTime, resolution: String): Single<String> {
        val sessionId = ObjectId().toHexString()
        return Completable.fromAction {
            insertSession(sessionId, streamId, title, startedAt, resolution)
        }
                .andThen(Single.just(sessionId))
                .subscribeOn(Schedulers.io())

    }

    private fun insertSession(sessionId: String, streamId: String, title: String, startedAt: DateTime, resolution: String) {
        StreamSessionRepository().createStreamSession(sessionId, streamId, title, startedAt, resolution)
    }
}
