package com.ekoapp.ekosdk.internal.usecase.stream

import com.amity.socialcloud.sdk.video.data.stream.StreamRepository
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution
import com.amity.socialcloud.sdk.video.stream.AmityStream
import io.reactivex.rxjava3.core.Single

internal class CreateStreamUseCase {

    fun execute(
        title: String,
        description: String,
        resolution: AmityBroadcastResolution,
        thumbnailFileId: String? = null
    ): Single<AmityStream> {
        return StreamRepository().createStream(
            title = title,
            description = description,
            resolution = resolution,
            thumbnailFileId = thumbnailFileId
        )
    }
}