package com.ekoapp.ekosdk.internal.usecase.stream

import com.amity.socialcloud.sdk.streamapi.PartialStreamData
import com.amity.socialcloud.sdk.video.stream.AmityStream
import io.reactivex.rxjava3.core.Single

internal class GetStreamDataUseCase {

    fun execute(streamId: String): Single<PartialStreamData> {
        FetchStreamUseCase().execute(streamId).subscribe()
        return ObserveStreamUseCase().execute(streamId)
            .firstOrError()
            .map {
                PartialStreamData(
                    streamId = streamId,
                    isLive = it.getStatus() == AmityStream.Status.LIVE,
                    resolution = it.getResolution() ?: "SD",
                    broadcastingUrl = it.getBroadcasterData()?.getUrl()
                )
            }
    }
}