package com.ekoapp.ekosdk.internal.usecase.stream

import com.amity.socialcloud.sdk.core.error.AmityError
import com.amity.socialcloud.sdk.core.error.AmityException
import com.amity.socialcloud.sdk.video.data.stream.StreamRepository
import com.amity.socialcloud.sdk.video.stream.AmityStream
import io.reactivex.rxjava3.core.Flowable

internal class ObserveStreamUseCase {

    fun execute(streamId: String): Flowable<AmityStream> {
        return if (streamId.isEmpty()) {
            Flowable.error(
                AmityException.create(
                    "stream not found",
                    null,
                    AmityError.ITEM_NOT_FOUND
                )
            )
        } else {
            StreamRepository().observeStream(streamId)
        }
    }
}