package com.ekoapp.ekosdk.internal.usecase.stream

import com.ekoapp.ekosdk.internal.repository.stream.StreamSessionRepository
import com.ekoapp.ekosdk.stream.StreamSessionSyncState
import com.ekoapp.ekosdk.stream.entity.EkoStreamSessionEntity
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers
import java.util.concurrent.TimeUnit

internal class SyncPendingSessionUseCase {

    fun execute() {
        jitter().flatMapCompletable {
            Completable.fromAction { StreamSessionRepository().resetSyncState() }
                    .andThen(queryPendingSyncSession())
                    .flatMapCompletable { sendToSever(it) }
        }.subscribeOn(Schedulers.io())
                .subscribe()

    }

    private fun sendToSever(streamSessions: List<EkoStreamSessionEntity>): Completable {
        return SendStreamSessionUseCase().execute(streamSessions, true)
                .subscribeOn(Schedulers.io())
    }

    private fun jitter(): Single<Long> {
        val jitter = (MIN_JITTER..MAX_JITTER).random().toLong()
        return Single.timer(jitter, TimeUnit.SECONDS, Schedulers.io())
    }

    private fun queryPendingSyncSession(): Single<List<EkoStreamSessionEntity>> {
        return StreamSessionRepository().getStreamSessionCollection(arrayOf(StreamSessionSyncState.PENDING)).firstOrError()
    }
}

private const val MIN_JITTER = 5
private const val MAX_JITTER = 30
