package com.ekoapp.ekosdk.internal.usecase.stream

import com.ekoapp.ekosdk.internal.repository.stream.StreamSessionRepository
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers
import org.joda.time.DateTime

internal class UpdateStreamSessionUseCase {

    fun execute(sessionId: String, duration: Long?, endedAt: DateTime?): Completable {
        return updateSession(sessionId, duration, endedAt)
            .subscribeOn(Schedulers.io())
    }

    private fun updateSession(sessionId: String, duration: Long?, endedAt: DateTime?): Completable {
        return StreamSessionRepository().getById(sessionId)
            .firstOrError()
            .map { session ->
                duration?.let { session.watchSeconds = it }
                endedAt?.let { session.endTime = it }
                StreamSessionRepository().updateStreamSession(session)
            }.ignoreElement()
    }
}
