package com.ekoapp.ekosdk.internal.usecase.user

import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.ekoapp.ekosdk.internal.constants.FLAG_TYPES
import com.ekoapp.ekosdk.internal.report.AmityFlagType
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import io.reactivex.rxjava3.core.Completable

internal class FlagUserUseCase {

    fun execute(userId: String, vararg flagTypes: AmityFlagType): Completable {
        EkoPreconditions.checkValidParameter(flagTypes, FLAG_TYPES)

        return UserRepository().flagUser(userId)
    }
}