package com.ekoapp.ekosdk.internal.usecase.user

import com.amity.socialcloud.sdk.core.data.follow.FollowRepository
import com.amity.socialcloud.sdk.core.user.AmityFollowRelationship
import com.amity.socialcloud.sdk.core.user.AmityFollowStatusFilter
import io.reactivex.rxjava3.core.Flowable

internal class FollowerReactorUseCase {

    fun execute(
        userId: String,
        filter: AmityFollowStatusFilter
    ): Flowable<AmityFollowRelationship> {
        return FollowRepository().getLatestFollower(
            userId = userId,
            filter = filter
        )
    }
}