package com.ekoapp.ekosdk.internal.usecase.user

import com.amity.socialcloud.sdk.chat.channel.AmityChatSettings
import com.ekoapp.ekosdk.internal.ChatSettingsEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.Flowable

internal class GetChatSettingsUseCase {
    fun execute(): Flowable<AmityChatSettings> {
        val channelDao = UserDatabase.get().chatSettingsDao()
        return channelDao.getChatSettings(ChatSettingsEntity.CHAT_SETTINGS_ID).map {
            AmityChatSettings(
                isEnabled = it.enabled,
                isMentionChannelEnabled = it.isAllowMentionedChannelEnabled
            )
        }
    }
}