package com.ekoapp.ekosdk.internal.usecase.user

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.core.data.follow.FollowRepository
import com.amity.socialcloud.sdk.core.user.AmityFollowRelationship
import com.amity.socialcloud.sdk.core.user.AmityFollowStatusFilter
import io.reactivex.rxjava3.core.Flowable

internal class GetUserFollowingsPagedListDataUseCase {
    fun execute(userId: String): Flowable<PagedList<AmityFollowRelationship>> {
        return FollowRepository().getFollowingsPagedList(userId, AmityFollowStatusFilter.ACCEPTED)
    }
}