package com.ekoapp.ekosdk.internal.usecase.user

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingData
import com.amity.socialcloud.sdk.core.data.follow.FollowRepository
import com.amity.socialcloud.sdk.core.user.AmityFollowRelationship
import com.amity.socialcloud.sdk.core.user.AmityFollowStatusFilter
import io.reactivex.rxjava3.core.Flowable

internal class GetUserFollowingsPagingDataUseCase {

    @ExperimentalPagingApi
    fun execute(userId: String): Flowable<PagingData<AmityFollowRelationship>> {
        return FollowRepository().getFollowingsPagingData(userId, AmityFollowStatusFilter.ACCEPTED)
    }
}